using System;
using Server.Targeting;
using Server;

namespace Server.Items
{
	[Flipable( 0x1030, 0x1031 )]
   public class BoardTransmutationPlane : Item
	{
		private int m_UsesRemaining;

		[CommandProperty( AccessLevel.GameMaster )]
		public int UsesRemaining
		{
			get { return m_UsesRemaining; }
			set { m_UsesRemaining = value; InvalidateProperties(); }
		}

      [Constructable]
		public BoardTransmutationPlane() : this( 200 )
		{
		}
		[Constructable]
		public BoardTransmutationPlane( int uses ) : base( 0x1030 )
		{
			Weight = 2.0;
			Hue = 101;
			UsesRemaining = uses;
			Name = "board transmutation jointing plane";
		}

		public BoardTransmutationPlane( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			list.Add( 1060584, m_UsesRemaining.ToString() ); // uses remaining: ~1_val~
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) )
			{
            from.SendMessage( "Vyber prkna pro transmutaci" );
            from.Target = new InternalTarget( this );
         }
			else
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
		}

		public void Transmute( Mobile from, object o )
		{
			if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
				return;
			}
			else if ( !(o is BaseBoards) )
			{
			   from.SendMessage( "Board transmutation plane lze pouzit pouze na prkna" );
				return;
			}
			else if( !((Item)o).IsChildOf(from.Backpack) )
			{
			   from.SendMessage( "Prkna musis mit v batohu" );
				return;
			}
			else if ( o is FrostwoodBoard )
			{
			   from.SendMessage( "Frostwood Boards jiz nelze vylepsit" );
				return;
			}
         else
         {
			   Item stary = o as Item;
			   Item novy = null;
			   
            if ( stary is Board )
               novy = new PineBoard();
            else if ( stary is PineBoard )
               novy = new CedarBoard();
            else if ( stary is CedarBoard )
                novy = new CherryBoard();
            else if ( stary is CherryBoard )
               novy = new MahoganyBoard();
            else if ( stary is MahoganyBoard )
               novy = new OakBoard();
            else if ( stary is OakBoard )
               novy = new AshBoard();
            else if ( stary is AshBoard )
               novy = new YewBoard();
            else if ( stary is YewBoard )
               novy = new HeartwoodBoard();
            else if ( stary is HeartwoodBoard )
               novy = new BloodwoodBoard();
            else if ( stary is BloodwoodBoard )
               novy = new FrostwoodBoard();
            else
               return;
               
            if ( UsesRemaining >= stary.Amount )
            {
               ((Item)novy).Amount = stary.Amount;
               stary.Delete();
               UsesRemaining -= ((Item)novy).Amount;
               from.AddToBackpack( (Item) novy );
            }
            else
            {
               ((Item)novy).Amount = UsesRemaining;
               ((Item)o).Amount -= UsesRemaining;
               UsesRemaining = 0;
               from.AddToBackpack( (Item) novy );
            }
            
            from.PlaySound( 0x244 );
            from.SendMessage( "Transmutace byla uspesne dokoncena" );
               
				if ( UsesRemaining <= 0 )
				{
					from.SendMessage( "Board transmutation plane vypotrebovan" );
					Delete();
				}
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			writer.Write( (int) m_UsesRemaining );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			m_UsesRemaining = reader.ReadInt();
		}

		private class InternalTarget : Target
		{
			private BoardTransmutationPlane m_Tool;

			public InternalTarget( BoardTransmutationPlane tool ) : base( 2, true, TargetFlags.None )
			{
				m_Tool = tool;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				m_Tool.Transmute( from, targeted );
			}
		}
	}
}